<?php
/**
 * Plugin Name: The Courier Guy Shipping for WooCommerce
 * Description: The Courier Guy WP & Woocommerce Shipping functionality.
 * Author: The Courier Guy
 * Author URI: https://www.thecourierguy.co.za/
 * Version: 4.3.4
 * Plugin Slug: wp-plugin-the-courier-guy
 * Text Domain: the-courier-guy
 * WC requires at least: 4.3.0
 * WC tested up to: 4.9.1
 */

if ( ! defined('ABSPATH')) {
    exit;
}
$dependencyPlugins = [
    'woocommerce/woocommerce.php' => [
        'notice' => 'Please install Woocommerce before attempting to install the The Courier Guy plugin.'
    ],
];
require_once('Includes/ls-framework-custom/Core/CustomPluginDependencies.php');
require_once('Includes/ls-framework-custom/Core/CustomPlugin.php');
require_once('Includes/ls-framework-custom/Core/CustomPostType.php');
require_once('Includes/ls-framework-custom/Core/CurlController.php');
$dependencies      = new CustomPluginDependencies(__FILE__);
$dependenciesValid = $dependencies->checkDependencies($dependencyPlugins);
if ($dependenciesValid && ! class_exists('TCG_Plugin') && class_exists('WC_Shipping_Method')) {
    require_once('Core/TCG_Plugin.php');
    global $TCG_Plugin;
    $TCG_Plugin            = new TCG_Plugin(__FILE__);
    $GLOBALS['TCG_Plugin'] = $TCG_Plugin;
    register_activation_hook(__FILE__, [$TCG_Plugin, 'activatePlugin']);
    register_deactivation_hook(__FILE__, [$TCG_Plugin, 'deactivatePlugin']);
} else {
    deactivate_plugins(plugin_basename(__FILE__));
    unset($_GET['activate']);
}
